/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.util;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.das2.datum.Units;

public final class CsvFileLogHandler
extends Handler
implements Closeable,
Flushable {
    private final BufferedWriter out;
    private final boolean writeHeader;
    private boolean headerWritten = false;
    private static final DateTimeFormatter ISO = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault());

    public CsvFileLogHandler() throws IOException {
        this(new File("/tmp/autoplot.log.csv").toPath());
    }

    public CsvFileLogHandler(Path file) throws IOException {
        this(file, StandardCharsets.UTF_8, true);
    }

    public CsvFileLogHandler(Path file, Charset charset, boolean writeHeader) throws IOException {
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(charset, "charset");
        this.writeHeader = writeHeader;
        Path parent = file.toAbsolutePath().getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        this.out = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE), charset));
        this.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord r) {
        if (r == null || !this.isLoggable(r)) {
            return;
        }
        CsvFileLogHandler csvFileLogHandler = this;
        synchronized (csvFileLogHandler) {
            try {
                if (this.writeHeader && !this.headerWritten) {
                    this.writeRow(new String[]{"timestamp_iso", "epoch_millis", "level", "thread", "logger", "source_class", "source_method", "message", "thrown"});
                    this.headerWritten = true;
                }
                long millis = r.getMillis();
                String timestampIso = Units.ms1970.createDatum(millis).toString();
                String epochMillis = Long.toString(millis);
                String level = Integer.toString(r.getLevel().intValue());
                String logger = CsvFileLogHandler.safe(r.getLoggerName());
                String thread = Integer.toString(r.getThreadID());
                String sourceClass = CsvFileLogHandler.safe(r.getSourceClassName());
                String sourceMethod = CsvFileLogHandler.safe(r.getSourceMethodName());
                String message = this.formatMessage(r);
                String thrown = CsvFileLogHandler.throwableToString(r.getThrown());
                this.writeRow(new String[]{timestampIso, epochMillis, level, thread, logger, sourceClass, sourceMethod, message, thrown});
            }
            catch (IOException e) {
                this.reportError("CSV log write failed", e, 1);
            }
            catch (RuntimeException e) {
                this.reportError("CSV log write failed (runtime)", e, 0);
            }
        }
    }

    private String formatMessage(LogRecord r) {
        try {
            Formatter f = this.getFormatter();
            String s = f != null ? f.formatMessage(r) : r.getMessage();
            return s == null ? "" : s;
        }
        catch (Exception e) {
            String s = r.getMessage();
            return s == null ? "" : s;
        }
    }

    private void writeRow(String[] cols) throws IOException {
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                this.out.write(44);
            }
            this.out.write(CsvFileLogHandler.csvEscape(cols[i]));
        }
        this.out.write("\n");
    }

    private static String csvEscape(String s) {
        if (s == null) {
            s = "";
        }
        boolean mustQuote = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\"' && c != ',' && c != '\n' && c != '\r') continue;
            mustQuote = true;
            break;
        }
        if (!mustQuote) {
            return s;
        }
        StringBuilder b = new StringBuilder(s.length() + 16);
        b.append('\"');
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                b.append("\"\"");
                continue;
            }
            b.append(c);
        }
        b.append('\"');
        return b.toString();
    }

    private static String throwableToString(Throwable t) {
        if (t == null) {
            return "";
        }
        String msg = t.getMessage();
        return msg == null || msg.isEmpty() ? t.getClass().getName() : t.getClass().getName() + ": " + msg;
    }

    private static String safe(Level lvl) {
        return lvl == null ? "" : lvl.getName();
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        CsvFileLogHandler csvFileLogHandler = this;
        synchronized (csvFileLogHandler) {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                this.reportError("CSV log flush failed", e, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SecurityException {
        CsvFileLogHandler csvFileLogHandler = this;
        synchronized (csvFileLogHandler) {
            try {
                this.out.flush();
                this.out.close();
            }
            catch (IOException e) {
                this.reportError("CSV log close failed", e, 3);
            }
        }
    }
}

